
//created by bhashi
const express = require('express');
const app = express();
const port = 3000;
const db = require('./db_connection');
const bodyParser = require('body-parser');
const jwt = require('jsonwebtoken');
//db.createDatabase();


app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: true }));

app.post('/sendData', async (req, res) => {
   console.log(req.body);
   db.sendData(req.body, res);

});

app.post('/sendUserData', async (req, res) => {
   console.log(req.body);
   db.sendUserData(req.body, res);

});

app.post('/getEvents', async (req, res) => {
   // console.log('bhashi');
   db.getData(req.body, res);

});


app.post('/login', async (req, res) => {
   console.log(req.body);
   db.getUser(req.body, res);

});

app.post('/requestChange', async (req, res) => {
   console.log(req.body);
   db.sendRequest(req.body, res);

});

app.post('/getRequests', async (req, res) => {
   // console.log('bhashi');
   db.getReq(req.body, res);

});

app.post('/updateEvents', async (req, res) => {
   // console.log('bhashi');
   db.updateEvents(req.body, res);

});


app.post('/deleteEvents', async (req, res) => {
   // console.log('bhashi');
   db.deleteEvents(req.body, res);

});


app.post('/readReqs', async (req, res) => {
   // console.log('bhashi');
   db.readReqs(req.body, res);

});



app.listen(port, () => console.log(`Server Runs on port ${port}!`))