<?php 

require_once DOC_ROOT.'vendor/autoload.php';

use Medoo\Medoo;

class Bcusers
{
	private $table_name = "bcusers";
	protected $connection;

	function __construct()
	{
		$database = new medoo([
		    'database_type' => 'mysql',
		    'database_name' => DB_NAME,
		    'server' => DB_HOST,
		    'username' => DB_USER,
		    'password' => DB_PASS,
		    'charset' => 'utf8'
		]); 

		$this->connection = $database;
	}

	function store($data){
		$status = $this->connection->insert($this->table_name, [            
            "name" => strip_tags($data['name']),  
            "phone" => strip_tags($data['phone']),  
            "mobile" => strip_tags($data['mobile']), 
            "brc" => strip_tags($data['brc']),
            "address" => strip_tags($data['address']),    
            "email" => strip_tags($data['email']),   
            "status" => strip_tags($data['status']),  
            "propic" => strip_tags($data['propic']), 
            "password" => md5(strip_tags($data['password'])),                 
            "created_at" => strip_tags($data['created_at'])
        ]);

        return $status;
	}

	function update($data){

			$status = $this->connection->update($this->table_name, [
	        "name" => strip_tags($data['name']),  
            "phone" => strip_tags($data['phone']),  
            "mobile" => strip_tags($data['mobile']), 
            "brc" => strip_tags($data['brc']),
            "address" => strip_tags($data['address']),    
            "email" => strip_tags($data['email']),  
            "status" => strip_tags($data['status']),              
            "propic" => strip_tags($data['propic']),     
            "password" => md5(strip_tags($data['password'])),           	            
	        "updated_at" => strip_tags($data['updated_at'])
	        ], ["id" => strip_tags($data['id'])]);
	    

        return $status;
	}

	function updateStatus($status,$id){
		$status = $this->connection->update($this->table_name, [
            "status" => $status
            
        ], ["id" => $id]);
        return $status;
	}

	function delete($id){

		$status = $this->connection->delete($this->table_name, " WHERE id=$id ");
		return $status;
	}

	function selectAll(){

		$data = $this->connection->select($this->table_name, '*', 'WHERE status=1 ORDER BY id DESC');
		return $data;
	}

	function selectAlldata(){

		$data = $this->connection->select($this->table_name, '*', '');
		return $data;
	}

	function selectAllbyId($id){

		$data = $this->connection->select($this->table_name, '*', "WHERE id=$id");
		return $data;
	}

	function selectAllQuery(){
		return "SELECT * FROM $this->table_name WHERE status=1 ORDER BY id DESC" ;
	}

	function selectAllQuerybyBcusers($id){
		return "SELECT * FROM $this->table_name WHERE type=$id " ;
	}

	

	function getById($id){

		$data = $this->connection->select($this->table_name, '*', " WHERE id=$id AND deleted_at IS NULL");
		return $data;
	}

	function getusernamebyid($id){

		$data = $this->connection->select($this->table_name, '*', " WHERE id=$id ");
		return $data;
	}

	static function getBcusersCategory(){
            return array("O/L", "A/L","Bachelor","Masters","Doctor");
      }

      function getByUsernameAndEmailCompany($email, $password){
    $data = $this->connection->select($this->table_name, '*', " WHERE status=1 AND email='$email' AND password='".md5($password)."' AND deleted_at IS NULL");
    return $data;
  }

	static function getAcceptedStatusType(){
            return array("Pending","Approved","Declined");
      }

	 function selectAllQueryforApproval(){
            return "SELECT * FROM $this->table_name WHERE status=0 OR status=2 AND deleted_at IS NULL ORDER BY id DESC" ;
      }

    function setAsStatus($data){

    		if ($data['status']==1) {
    			 $status = $this->connection->update($this->table_name, [  
    			    "password" => md5(strip_tags($data['password'])),           
		            "status" => strip_tags($data['status'])          
		     	   ], ["id" => strip_tags($data['id'])]);

    		}else{

    			 $status = $this->connection->update($this->table_name, [            
           		 "status" => strip_tags($data['status'])          
     	 		  ], ["id" => strip_tags($data['id'])]);

    		}           


        return $status;
      }


     // ************added by ayona***********
    
    function selectById($id){ 

    	$data = $this->connection->select($this->table_name, '*', " WHERE id=$id ");
		return $data;

    }


    function updateCompnayProfile($data){
    	// print_r($data);die();
			$status = $this->connection->update($this->table_name, [
	        "name" => strip_tags($data['name']),  
            "phone" => strip_tags($data['phone']),
            "mobile" => strip_tags($data['mobile']),
            "brc" => strip_tags($data['brc']),
            "propic" => strip_tags($data['propic']),
            "address" => strip_tags($data['address']),    
            "email" => strip_tags($data['email']),  
	        "updated_at" => strip_tags($data['updated_at'])
	        ], ["id" => strip_tags($data['id'])]);
	    

        return $status;
	}
	
	function updatePassword($data){
			$status = $this->connection->update($this->table_name, [
            "password" => md5(strip_tags($data['password'])),  
	        "updated_at" => strip_tags($data['updated_at'])
	        ], ["id" => strip_tags($data['id'])]);
	    

        return $status;
	}

	function selectByEmail($email){

		$data = $this->connection->select($this->table_name, '*', " WHERE email = '$email' AND deleted_at IS NULL");
		return $data;
	}

	function tokenInsert($data){
		
		$status = $this->connection->update($this->table_name, [
            "token" => strip_tags($data['token'])
            
        ], ["id" => strip_tags($data['id'])]);
        return $status;

	}
	
	
    function resetPassword($data){
			$status = $this->connection->update($this->table_name, [
            "password" => md5(strip_tags($data['password'])),  
	        "updated_at" => strip_tags($data['updated_at'])
	        ], ["id" => strip_tags($data['id'])]);
	    

        return $status;
	}  

    // **********/.added by ayona***********


}

?>