<?php 

require_once '../config.php';

$action = strip_tags($_POST['action']); 

switch ($action) {
	case 'index':
		index();
		break;

	case 'store':
		store();
		break;

	case 'edit':
		edit();
		break;

	case 'update':
		update();
		break;

	case 'destroy':
		destroy();
		break;

	

	case 'logout':
		logout();
		break;
	case 'filterview':
		filterview();
		break;	

}


function index(){

	$jobcategory = new Jobcategory();
	$all = $jobcategory->selectAll();

	$page = strip_tags($_POST['page']);
	$limit = 10;
	$link = SITE_URL.'modules/jobcategory/?page=';
	$class = 'pagination';

	$Pager = new Pager();
	$query = $jobcategory->selectAllQuery();
	$Buttons = array('&laquo;', '&raquo;');

	$pagination = '';

	$data = $Pager->pager($query, $page, $limit);
	if(count($all)>$limit){
		$Pager->getPager();
		$pagination .= $Pager->getPagerStyle($Buttons, $class, $link);
	}

	$out = '';
	$modal = '';
	$category_data = Jobcategory::getJobcategoryCategory();


	foreach ($data as $row) {


		$out .= '<tr id="row'.$row['id'].'">';
		$out .= '<td>'.$row['id'].'</td>';
		$out .= '<td>'.$row['name'].'</td>';				
		$out .= '<td>'.$row['created_at'].'</td>';		
		

		$val = Common::getPermissions("jobcategory","edit");
              if ($val== 1) {  

				$editview = '<a href="'.SITE_URL.'modules/jobcategory/edit.php?id='.$row['id'].'">
		   		<i class="metismenu-icon pe-7s-back-2" aria-hidden="true"></i> </a>';
		   				    }

		   				 $val = Common::getPermissions("jobcategory","delete");
              if ($val== 1) { 
				$deleteaction = '<a href="javascript:;" class="text-danger"
		  						   onclick="deleteUser('.$row['id'].');"> ';
		  					}


		$out .= '<td> '.$editview.'    	

		     &nbsp; &nbsp;'.$deleteaction.'
		     <i class="metismenu-icon pe-7s-delete-user" aria-hidden="true"></i></a></td>';
		$out .= '</tr>';


	}

	foreach ($data as $row) {
		$modal .= '<div id="delete_'.$row['id'].'" class="modal fade" role="dialog">
				  <div class="modal-dialog">

				    <div class="modal-content">
				      <div class="modal-header">
				        <button type="button" class="close" data-dismiss="modal">&times;</button>
				        <h4 class="modal-title">Delete User</h4>
				      </div>
				      <div class="modal-body">
				        <p>Are you sure you want to delete this user.</p>
				      </div>
				      <div class="modal-footer">
				      <button type="button" class="btn btn-success" data-dismiss="modal">No</button>
				        <button type="button" class="btn btn-danger" onclick="deleteUser('.$row['id'].')">Yes</button>
				      </div>
				    </div>

				  </div>
				</div>';
	}
	echo json_encode(array('table'=>$out,'modal'=>$modal,'pagination'=>$pagination));
}

function create(){
  echo 'create';
}

function store(){

	//print_r($_POST);die();

	$date = date("Y-m-d H:i:s");

	$data = $_POST;


	$data['created_at'] = $date;
	$data['created_by'] = Sessions::getAdminFullName();

	$jobcategory = new Jobcategory();
	$insert  = $jobcategory->store($data);

	if($insert){
		$activity_log = new ActivityLog();
		$activity_log->newLogRecord('jobcategory','add','Jobcategory Added.');
		echo 200;
	}else{
		echo 400;
	}
}

function show(){
  echo 'show';
}

function edit(){
  echo 'edit';
}

function update(){

	date_default_timezone_set('Asia/Colombo');
	$date = date("Y-m-d H:i:s");

	$data = $_POST;

	// print_r($data);die();
	$data['updated_at'] = $date;

	$jobcategory = new Jobcategory();
	$updates = $jobcategory->update($data);

	if($updates){
		$activity_log = new ActivityLog();
		$activity_log->newLogRecord('jobcategory','edit','Jobcategory Edited.');
		echo 200;
	}else{
		echo 400;
	}
}

function destroy(){
	
	$jobcategory = new Jobcategory();
	$delete = $jobcategory->delete(strip_tags($_POST['id']));

	if($delete){
		$activity_log = new ActivityLog();
		$activity_log->newLogRecord('jobcategory','delete','Jobcategory Deleted.');
		echo 200;
	}else{
		echo 400;
	}
}



function logout(){

	Sessions::logoutAdmin();
	echo 200;
}

function filterview(){

    $filterid = strip_tags($_POST['id']);
   

    $jobcategory = new Jobcategory();
	$all = $jobcategory->selectAllbyId($filterid);

  

	$page = strip_tags($_POST['page']);
	$limit = 10;
	$link = SITE_URL.'jobcategory/?page=';
	$class = 'pagination';

	$Pager = new Pager();
	$query = $jobcategory->selectAllQuerybyJobcategory($filterid);

  

	$Buttons = array('&laquo;', '&raquo;');

	$pagination = '';

	$data = $Pager->pager($query, $page, $limit);
	if(count($all)>$limit){
		$Pager->getPager();
		$pagination .= $Pager->getPagerStyle($Buttons, $class, $link);
	}

	$out = '';
	$modal = '';
	foreach ($data as $row) {

		$out .= '<tr id="row'.$row['id'].'">';
		$out .= '<td>'.$row['id'].'</td>';
		$out .= '<td>'.$row['name'].'</td>';
		$out .= '<td>'.$row['amount'].'</td>';
		$out .= '<td>'.$row['created_at'].'</td>';
		

		if ($row['type']=="1") {
			$out .= '<td>'."Percentage".'</td>';
		}else{
			$out .= '<td>'."Value".'</td>';
		}
		

		$val = Common::getPermissions("jobcategory","edit");
              if ($val== 1) {  

				$editview = '<a href="'.SITE_URL.'modules/jobcategory/edit.php?id='.$row['id'].'">
		   		<i class="fa fa-pencil-square-o fa-lg" aria-hidden="true"></i> </a>';
		   				    }

		   				 $val = Common::getPermissions("jobcategory","delete");
              if ($val== 1) { 
				$deleteaction = '<a href="javascript:;" class="text-danger"
		  						   onclick="deleteUser('.$row['id'].');"> ';
		  					}


		$out .= '<td> '.$editview.'    	

		     &nbsp; &nbsp;'.$deleteaction.'
		     <i class="fa fa-times fa-lg" aria-hidden="true"></i></a></td>';
		$out .= '</tr>';


	}

	foreach ($data as $row) {
		$modal .= '<div id="delete_'.$row['id'].'" class="modal fade" role="dialog">
				  <div class="modal-dialog">

				    <div class="modal-content">
				      <div class="modal-header">
				        <button type="button" class="close" data-dismiss="modal">&times;</button>
				        <h4 class="modal-title">Delete User</h4>
				      </div>
				      <div class="modal-body">
				        <p>Are you sure you want to delete this user.</p>
				      </div>
				      <div class="modal-footer">
				      <button type="button" class="btn btn-success" data-dismiss="modal">No</button>
				        <button type="button" class="btn btn-danger" onclick="deleteUser('.$row['id'].')">Yes</button>
				      </div>
				    </div>

				  </div>
				</div>';
	}
	echo json_encode(array('table'=>$out,'modal'=>$modal,'pagination'=>$pagination));

	
}
?>